<?php
namespace gallery\system\event\listener;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\request\LinkHandler;
use wcf\system\Callback;
use wcf\system\Regex;
use wcf\data\bbcode\BBCode;

class GalleryPreParserExtendedListener implements IParameterizedEventListener {

    public function execute($eventObj, $className, $eventName, array &$parameters) {
		
		if (!$eventObj->text) return;
		
		// check if needed url and album BBCode is allowed
		if ($eventObj->allowedBBCodes !== null && (!BBCode::isAllowedBBCode('url', $eventObj->allowedBBCodes) || !BBCode::isAllowedBBCode('album', $eventObj->allowedBBCodes))) {
			return;
		}
		
		// build search pattern
		$galleryAlbumURL = preg_quote(LinkHandler::getInstance()->getLink('album', array(
			'application' => 'gallery'
		)));
		
		$galleryAlbumURL = preg_replace('~^https?~', 'https?', $galleryAlbumURL);
		$regex = new Regex("((\[url=')|(\[url\]))".$galleryAlbumURL."(?<ID>\d+).*\[/url\]");

		
        $callback = new Callback(function($matches) {
			return '[album]'.$matches['ID'].'[/album]';
        });

		$eventObj->text = $regex->replace($eventObj->text, $callback);
		
    }
}
