<?php
namespace calendar\system\event\listener;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\request\LinkHandler;
use wcf\system\Callback;
use wcf\system\Regex;
use wcf\data\bbcode\BBCode;

class CalendarPreParserExtendedListener implements IParameterizedEventListener {

    public function execute($eventObj, $className, $eventName, array &$parameters) {
		
		if (!$eventObj->text) return;
		
		// check if needed url and event BBCode is allowed
		if ($eventObj->allowedBBCodes !== null && (!BBCode::isAllowedBBCode('url', $eventObj->allowedBBCodes) || !BBCode::isAllowedBBCode('event', $eventObj->allowedBBCodes))) {
			return;
		}
		
		// build search pattern
		$calendarURL = preg_quote(LinkHandler::getInstance()->getLink('Event', array(
			'application' => 'calendar'
		)));
		
		$calendarURL = preg_replace('~^https?~', 'https?', $calendarURL);
		$regex = new Regex("((\[url=')|(\[url\]))".$calendarURL."(?<ID>\d+).*\[/url\]");

		
        $callback = new Callback(function($matches) {
			return '[event]'.$matches['ID'].'[/event]';
        });

		$eventObj->text = $regex->replace($eventObj->text, $callback);
		
    }
}
