<?php
namespace wcf\system\bbcode\media\provider;
use wcf\system\request\RouteHandler;

/**
 * Media provider callback for CNN urls.
 *
 * @author	René Jung (The_Waiters)
 * @license	License terms for non-commercial products <https://destinaja.de/page/license/>
 * @package	WoltLabSuite\Core\System\Bbcode\Media\Provider
 * @since	3.1
 */
 
class CNNBBCodeMediaProvider implements IBBCodeMediaProvider {

	public function parse($url, array $matches = []) {
				
		$contentProperties = '';
		$styleProperties = '';

		
		if (preg_match('~^(https?)://~', $matches[0], $protocol)) {
			
			if ($protocol[1] === 'http' && RouteHandler::secureConnection()) {
				
				return '<a href="' . $matches[0] . '" class="externalURL"' . ((EXTERNAL_LINK_REL_NOFOLLOW || EXTERNAL_LINK_TARGET_BLANK) ? (' rel="' . (EXTERNAL_LINK_REL_NOFOLLOW ? 'nofollow' : '') . ((EXTERNAL_LINK_REL_NOFOLLOW && EXTERNAL_LINK_TARGET_BLANK) ? ' ' : '') . (EXTERNAL_LINK_TARGET_BLANK ? 'noopener noreferrer' : '') . ' me"') : ' rel="me"') . (EXTERNAL_LINK_TARGET_BLANK ? ' target="_blank"' : '') . '>' . $matches[0] . ' (Non-SSL)</a>';
			
			} else {

				$providerClass = 'CNN';
				
				$contentProperties = ' frameborder="0" scrolling="no"';
				
				$playerContent = '<iframe src="http://edition.cnn.com/video/api/embed.html#/video/' . $matches['REFERENCE'] . '"' . $contentProperties . $styleProperties . '></iframe>';
								
				$playerContainer = '<div class="videoContainer ' . $providerClass . '">' . $playerContent . '</div>';
				
				return $playerContainer;
			}
		}
	}
}