<?php
namespace wcf\system\bbcode\media\provider;
use wcf\system\request\RouteHandler;
use wcf\system\exception\SystemException;
use wcf\system\WCF;
use wcf\util\HTTPRequest;
use wcf\util\JSON;

/**
 * Media provider callback for Twitter urls.
 *
 * @author	René Jung (The_Waiters)
 * @license	License terms for non-commercial products <https://destinaja.de/page/license/>
 * @package	WoltLabSuite\Core\System\Bbcode\Media\Provider
 * @since	3.1
 */
 
class TwitterBBCodeMediaProvider implements IBBCodeMediaProvider {

	public function parse($url, array $matches = []) {
		

		if (preg_match('~^(https?)://~', $matches[0], $protocol)) {
			
			if ($protocol[1] === 'http' && RouteHandler::secureConnection()) {
				
				$matches[0] = 'https' . mb_substr($matches[0], 4);
			
			} 
		}

		$request = new HTTPRequest('https://publish.twitter.com/oembed?url=' . $matches[0] , ['timeout' => 10]);
		
		try {
			$request->execute();
			$reply = $request->getReply();
			$data = JSON::decode($reply['body']);
		
			if ($data['url']) {
				return $data["html"];
			} 
			else {
				throw new SystemException('Can not connect to https://publish.twitter.com/oembed');
			}
		}
		
		catch (SystemException $e) {
				throw new SystemException('Request to Twitter failed. Please inform the Administrator about: ' . $e->getMessage());
		}
		
	}
}