<?php
namespace wcf\system\bbcode\media\provider;
use wcf\system\request\RouteHandler;

/**
 * Media provider callback for CNBC urls.
 *
 * @author	René Jung (The_Waiters)
 * @license	License terms for non-commercial products <https://destinaja.de/page/license/>
 * @package	WoltLabSuite\Core\System\Bbcode\Media\Provider
 * @since	3.1
 */
 
class CNBCBBCodeMediaProvider implements IBBCodeMediaProvider {

	public function parse($url, array $matches = []) {
				
		$contentProperties = '';
		$styleProperties = '';

		
		if (preg_match('~^(https?)://~', $matches[0], $protocol)) {
			
			if ($protocol[1] === 'http' && RouteHandler::secureConnection()) {
				
				return '<a href="' . $matches[0] . '" class="externalURL"' . ((EXTERNAL_LINK_REL_NOFOLLOW || EXTERNAL_LINK_TARGET_BLANK) ? (' rel="' . (EXTERNAL_LINK_REL_NOFOLLOW ? 'nofollow' : '') . ((EXTERNAL_LINK_REL_NOFOLLOW && EXTERNAL_LINK_TARGET_BLANK) ? ' ' : '') . (EXTERNAL_LINK_TARGET_BLANK ? 'noopener noreferrer' : '') . ' me"') : ' rel="me"') . (EXTERNAL_LINK_TARGET_BLANK ? ' target="_blank"' : '') . '>' . $matches[0] . ' (Non-SSL)</a>';
			
			} else {

				$providerClass = 'CNBC';
				
				$contentProperties = ' type="application/x-shockwave-flash" allowFullScreen="true" scrolling="no" bgcolor="#131313"';
				
				$playerContent = '<iframe src="http://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&byGuid=' . $matches['ID'] . '"' . $contentProperties . $styleProperties . '></iframe>';
				
				$playerContainer = '<div class="videoContainer ' . $providerClass . '">' . $playerContent . '</div>';
				
				return $playerContainer;
			}
		}
	}
}