<?php
namespace wcf\system\event\listener;
use wcf\data\style\StyleAction;
use wcf\system\image\ImageHandler;
use wcf\system\WCF;

class AdditionalMetaTagsEventListener implements IParameterizedEventListener {

	public function execute($eventObj, $className, $eventName, array &$parameters) {
		
		//do during upload favivon
		if ($eventObj->getActionName() == 'uploadFavicon'){		
			
			//get styleID
			$styleID = $eventObj->getParameters()['styleID']; 
			$fileExtension = WCF::getSession()->getVar('styleFavicon-template-'.$styleID);
			
			//create missing files
			if ($fileExtension) {
				$template = WCF_DIR . "images/favicon/{$styleID}.favicon-template.{$fileExtension}";
				$images = [
					'android-chrome-36x36.png' => 36,
					'android-chrome-48x48.png' => 48,
					'android-chrome-72x72.png' => 72,
					'android-chrome-96x96.png' => 96,
					'android-chrome-144x144.png' => 144,
					'android-chrome-192x192.png' => 192,
					'android-chrome-256x256.png' => 256,
					'apple-touch-icon-57x57.png' => 57,
					'apple-touch-icon-60x60.png' => 60,
					'apple-touch-icon-72x72.png' => 72,
					'apple-touch-icon-76x76.png' => 76,
					'apple-touch-icon-114x114.png' => 114,
					'apple-touch-icon-120x120.png' => 120,
					'apple-touch-icon-144x144.png' => 144,
					'apple-touch-icon-152x152.png' => 152,
					'apple-touch-icon-167x167.png' => 167,
					'favicon-16x16.png' => 16,
					'favicon-32x32.png' => 32,
					'favicon-96x96.png' => 96,
					'favicon-192x192.png' => 192,
					'favicon-194x194.png' => 194,
					'mstile-70x70.png' => 70,
					'mstile-150x150.png' => 150
				];
			
				$adapter = ImageHandler::getInstance()->getAdapter();
				$adapter->loadFile($template);
				foreach ($images as $filename => $length) {
					$thumbnail = $adapter->createThumbnail($length, $length);
					$adapter->writeImage($thumbnail, WCF_DIR."images/favicon/{$styleID}.{$filename}");
				}
			}

		}
		
		//do during save style-changes
		if ($eventObj->getActionName() == 'update'){	
		
			//wcfDebug($eventObj);
			
			//get StyleID
			$styleID = $eventObj->getObjectIDs()['0'];
			
			//get Theme-Color from Style
			$style_theme_color = $eventObj->getParameters()['variables']['wcfHeaderBackground']; 
			
			//convert $style_theme_color Color to hex
			if (preg_match('/^rgba\((\d+), (\d+), (\d+), (1|0\.\d+)\)$/', $style_theme_color, $matches)) {
				$r = $matches[1];
				$g = $matches[2];
				$b = $matches[3];
				$a = floatval($matches[4]);
				
				// calculate alpha value assuming a white canvas, source rgb will be (255,255,255) or #fff
				// see https://stackoverflow.com/a/2049362
				if ($a < 1) {
					$r = ((1 - $a) * 255) + ($a * $r);
					$g = ((1 - $a) * 255) + ($a * $g);
					$b = ((1 - $a) * 255) + ($a * $b);
					
					$clamp = function($v) {
						return max(0, min(255, intval($v)));
					};
					
					$r = $clamp($r);
					$g = $clamp($g);
					$b = $clamp($b);
				}
				
				$style_theme_color = sprintf('#%02x%02x%02x', $r, $g, $b);
			}
					
			//set Theme-Color
			if (META_THEMECOLOR != '') {
				$theme_color = META_THEMECOLOR;	
			} else {
				$theme_color = $style_theme_color;	
			}
			
			//set Title of bookmarks and shortcut
			if (META_APPTITLE) {
				$meta_apptitle = META_APPTITLE;
			} else {
				$meta_apptitle = PAGE_TITLE;
			}
			
			//set loading-color for chrome
			if (META_CHROME_LAUNCH_LOADING_COLOR != '') {
				$chrome_launch_loading_color = META_CHROME_LAUNCH_LOADING_COLOR;	
			} else {
				$chrome_launch_loading_color = $style_theme_color;	
			}
			
			//set display of adress-line
			if (META_CHROME_DISPLAY) {
				$chrome_display = 'browser';
			} else {
				$chrome_display = 'standalone';
			}
			
					
			// overwrite browserconfig.xml
			$browserconfig = <<<BROWSERCONFIG
<?xml version="1.0" encoding="utf-8"?>
<browserconfig>
    <msapplication>
        <tile>
			<square70x70logo src="{$styleID}.mstile-70x70.png"/>
            <square150x150logo src="{$styleID}.mstile-150x150.png"/>
            <TileColor>{$theme_color}</TileColor>
        </tile>
    </msapplication>
</browserconfig>
BROWSERCONFIG;
			file_put_contents(WCF_DIR . "images/favicon/{$styleID}.browserconfig.xml", $browserconfig);
			
			// overwrite manifest.json			
			$manifest = <<<MANIFEST
{
    "name": "{$meta_apptitle}",
    "icons": [
        {
            "src": "{$styleID}.android-chrome-36x36.png",
            "sizes": "36x36",
            "type": "image/png"
        },
        {
            "src": "{$styleID}.android-chrome-48x48.png",
            "sizes": "48x48",
            "type": "image/png"
        },
        {
            "src": "{$styleID}.android-chrome-72x72.png",
            "sizes": "72x72",
            "type": "image/png"
        },
        {
            "src": "{$styleID}.android-chrome-96x96.png",
            "sizes": "96x96",
            "type": "image/png"
        },
        {
            "src": "{$styleID}.android-chrome-144x144.png",
            "sizes": "144x144",
            "type": "image/png"
        },
        {
            "src": "{$styleID}.android-chrome-192x192.png",
            "sizes": "192x192",
            "type": "image/png"
        },
        {
            "src": "{$styleID}.android-chrome-256x256.png",
            "sizes": "256x256",
            "type": "image/png"
        }
    ],
	"theme_color": "{$theme_color}",
    "background_color": "{$chrome_launch_loading_color}",
    "display": "{$chrome_display}"
}
MANIFEST;
			file_put_contents(WCF_DIR . "images/favicon/{$styleID}.manifest.json", $manifest);
		
		}

	}
}