<?php
namespace wcf\system\event\listener;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\WCF;
 
class ClickAndLoadListener implements IParameterizedEventListener {

	public function execute($eventObj, $className, $eventName, array &$parameters) {
		
		$elements = $eventObj->getDocument()->getElementsByTagName('img');
		
		foreach ($elements as $element) {
			
			$class = $element->getAttribute('class');
			
			if (!preg_match('~\bsmiley\b~', $class)) {
			
				$src = $element->getAttribute('src');
				$alt = $element->getAttribute('alt');

				$element = $eventObj->renameTag($element, 'img-clickandload');
				
				$element->setAttribute('src', $src);
				
				if ($alt) {
					$element->setAttribute('alt', $alt);
				}
			}
		}
	}
}
