<?php
namespace wcf\system\html\output\node;
use wcf\system\html\output\node\HtmlOutputNodeImg;//
use wcf\system\html\node\AbstractHtmlNodeProcessor;//
use wcf\system\WCF;
use wcf\util\DOMUtil;

class HtmlOutputNodeImgClickandload extends HtmlOutputNodeImg {

	protected $tagName = 'img-clickandload';

	public function process(array $elements, AbstractHtmlNodeProcessor $htmlNodeProcessor) {
		parent::process($elements, $htmlNodeProcessor);
		
		foreach ($elements as $element) {
			
			$class = $element->getAttribute('class');
			
			if (!preg_match('~\bsmiley\b~', $class)) {
				
				//set rand ID
				$id = rand();
				
				//save original data
				$src = $element->getAttribute('src');
				$datavalid = $element->getAttribute('data-valid');
				$srcset = $element->getAttribute('srcset');
				$alt = $element->getAttribute('alt');

				//set placeholder image
				$img = $element->ownerDocument->createElement('img');
				$img->setAttribute('src', WCF::getPath() . 'images/play-circle.svg');
				
				//set script
				$img->setAttribute('onclick', "clickandload('" . $id . "')");
				
				//set new attributes
				$img->setAttribute('data-src', $src);
				
				if ($srcset) {
					$img->setAttribute('srcset', $srcset);
				}
				
				if ($class) {
					$img->setAttribute('class', $class . ' clickandload ' .$id);
				} else {
					$img->setAttribute('class', 'clickandload ' .$id);
				}
				
				if ($datavalid) {
					$img->setAttribute('data-valid', $datavalid);
				}
				
				if ($srcset) {
					$img->setAttribute('srcset', $srcset);
				}
				
				if ($alt) {
					$img->setAttribute('alt', $alt);
				}
				
				//insert new image
				$element->parentNode->insertBefore($img, $element);
				$img->appendChild($element);
				
				//delete old image
				DOMUtil::removeNode($element);
			}
		}
	}
}