<?php
namespace wcf\system\event\listener;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\application\ApplicationHandler;
use wcf\system\WCF;
 
class ClickAndLoadMediaListener implements IParameterizedEventListener {

	public function execute($eventObj, $className, $eventName, array &$parameters) {
		
		if (WCF::getUser()->userCanSkipClickAndLoad || isset($_COOKIE['clickandload'])) {
			
			$clickandloadprocess = '0';
			
		} else if (IMAGE_ALLOW_EXTERNAL_SOURCE) {
		
			$clickandloadprocess = '1';
			
		} else {
			
			$clickandloadprocess = '0';
		}
		
		if ($clickandloadprocess) {
		
			$elements = $eventObj->getDocument()->getElementsByTagName('woltlab-metacode');
			
			foreach ($elements as $element) {
				
				$name = $element->getAttribute('data-name');
				
				if (preg_match('~media~', $name)) {
					
					$external = true;
					$attributes = $element->getAttribute('data-attributes');
					$textContent = $element->textContent;
					
					//check for internal links
					if (ApplicationHandler::getInstance()->isInternalURL($textContent)) {
						$external = false;
					}
					
					//check for internal links via subdomain
					$parsedUrl = parse_url($textContent);
					
					$domainName = ApplicationHandler::getInstance()->getActiveApplication()->domainName;
					$domainName = preg_replace('~\:.*~', '', $domainName);
					
					if (preg_match("~$domainName~", $parsedUrl['host'])) {
						$external = false;
					}
					
					if ($external) {
						$element = $eventObj->renameTag($element, 'media-clickandload');
					
						$element->setAttribute('data-name', $name);
						$element->setAttribute('data-attributes', $attributes);
						$element->textContent = $textContent;
					}
				}
			}
		}
	}
}
