<?php
namespace wcf\system\html\output\node;
use wcf\system\bbcode\HtmlBBCodeParser;
use wcf\system\html\node\AbstractHtmlNodeProcessor;
use wcf\system\WCF;
use wcf\util\StringUtil;

class HtmlOutputNodeMediaClickandload extends AbstractHtmlOutputNode   {

	protected $tagName = 'media-clickandload';
	
	
	public function process(array $elements, AbstractHtmlNodeProcessor $htmlNodeProcessor) {
		/** @var \DOMElement $element */
		foreach ($elements as $element) {
			$name = $element->getAttribute('data-name');
			$attributes = $element->getAttribute('data-attributes');
			
			$nodeIdentifier = StringUtil::getRandomID();
			
			$element = $htmlNodeProcessor->renameTag($element, 'wcfNode-' . $nodeIdentifier);
			
			$htmlNodeProcessor->addNodeData($this, $nodeIdentifier, [
				'name' => $name,
				'attributes' => $htmlNodeProcessor->parseAttributes($attributes),
				'element' => $element
			]);
		}
	}
	
	
	public function replaceTag(array $data) {
		HtmlBBCodeParser::getInstance()->setOutputType($this->outputType);
			
		//load content
		$mediacontent = HtmlBBCodeParser::getInstance()->getHtmlOutput($data['name'], $data['attributes'], $data['element']);
		
		$plattern_media = '~clickandload~';
		$match_media = preg_match($plattern_media,$mediacontent,$matches);
		
		If ($match_media) {

			//get host
			$host = '';
			$scr = '';
			$plattern_scr = '~src="(?<SCR>https?://(www.)?(?<HOST>([a-z]+\.)?([^\/]*)).*)"~';
			
			$match_host = preg_match($plattern_scr,$mediacontent,$matches);
			
			if ( isset($matches['HOST']) && $matches['HOST'] != '' ) {
				$host = $matches['HOST'];
			}
			
			if ( isset($matches['SCR']) && $matches['SCR'] != '' ) {
				$scr = $matches['SCR'];
			}
			
			//get rand ID
			$id = rand();
			
			//get data_src
			$data_src = ' data-src="' . $scr . '"';
			
		
			/*compile new string*/
			
			//set placeholder image
			$img = 'src="'. WCF::getPath() . 'images/play-circle.svg"';
			$mediacontent = preg_replace($plattern_scr, $img, $mediacontent);
			
			//set id to classes
			$plattern_class = '~clickandload~';
			$class = 'clickandload ' . $id;
			$mediacontent = preg_replace($plattern_class, $class, $mediacontent);
			
			//set new source
			$plattern_iframe = '~<iframe~';
			$newdata = '<iframe' . $data_src;
			$mediacontent = preg_replace($plattern_iframe, $newdata, $mediacontent);
			
			//get script
			$script = "clickandload('" . $id . "')";
			$script = 'onclick="' . $script . '" ';
			
			//set description
			$description = WCF::getLanguage()->getDynamicVariable('wcf.page.clickAndLoad.clickAndLoad.source');
			$description = '<span class="button clickandloaddescription' . $id . '" ' . $script . '><span>' . $description . $host . ')</span></span>';
			
			$mediacontent = $mediacontent . $description;		
			
			//return final data
			return $mediacontent;
		
		} else {
			
			return $mediacontent;
		}	
	}
}