<?php
namespace wcf\system\html\output\node;
use wcf\system\html\node\AbstractHtmlNodeProcessor;
use wcf\system\WCF;
use wcf\util\DOMUtil;

class HtmlOutputNodeImgClickandload extends HtmlOutputNodeImg {

	protected $tagName = 'img-clickandload';

	public function process(array $elements, AbstractHtmlNodeProcessor $htmlNodeProcessor) {
		parent::process($elements, $htmlNodeProcessor);
		
		foreach ($elements as $element) {
			
			$class = $element->getAttribute('class');
			
			if (!preg_match('~\bsmiley\b~', $class)) {
				
				//set rand ID
				$id = rand();
				$host = '';
				
				//save original data
				$src = $element->getAttribute('src');
				$datavalid = $element->getAttribute('data-valid');
				$srcset = $element->getAttribute('srcset');
				$alt = $element->getAttribute('alt');
				
				//get host
				$plattern = '~https?://(www.)?(?<HOST>([a-z]+\.)?([^\/]*)).*~';
				$match_host = preg_match($plattern,$src,$matches);
				
				if ( isset($matches['HOST']) && $matches['HOST'] != '' ) {
					$host = $matches['HOST'];
				}

				//set placeholder image
				$img = $element->ownerDocument->createElement('img');
				$img->setAttribute('src', WCF::getPath() . 'images/play-circle.svg');
				
				//set new attributes
				$img->setAttribute('data-src', $src);
				
				if ($srcset) {
					$img->setAttribute('srcset', $srcset);
				}
				
				if ($class) {
					$img->setAttribute('class', $class . ' clickandload ' .$id);
				} else {
					$img->setAttribute('class', 'clickandload ' .$id);
				}
				
				if ($datavalid) {
					$img->setAttribute('data-valid', $datavalid);
				}
				
				if ($srcset) {
					$img->setAttribute('srcset', $srcset);
				}
				
				if ($alt) {
					$img->setAttribute('alt', $alt);
				}
				
				
				//set description
				if ($host) {
					
					$span = $element->ownerDocument->createElement('span');
					
					$description = WCF::getLanguage()->getDynamicVariable('wcf.page.clickAndLoad.clickAndLoad.source');
					$span->textContent = $description . $host . ")";
					
					
					$span->setAttribute('class', 'button clickandloaddescription' . $id);
					
					$span->setAttribute('onclick', "clickandload('" . $id . "')");

				}
				
				//insert new image
				$element->parentNode->insertBefore($img, $element);
				
				//insert new description
				if ($host) {
					$element->parentNode->insertBefore($span, $element);
				}
				
				$img->appendChild($element);
				
				//delete old image
				DOMUtil::removeNode($element);
			}
		}
	}
}