<?php
namespace wcf\system\event\listener;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\application\ApplicationHandler;
use wcf\system\WCF;
 
class ClickAndLoadImgListener implements IParameterizedEventListener {

	public function execute($eventObj, $className, $eventName, array &$parameters) {
		
		if (WCF::getUser()->userCanSkipClickAndLoad || isset($_COOKIE['clickandload'])) {
			
			$clickandloadprocess = '0';
			
		} else if (IMAGE_ALLOW_EXTERNAL_SOURCE) {
		
			$clickandloadprocess = '1';
			
		} else {
			
			$clickandloadprocess = '0';
		}
		
		if ($clickandloadprocess) {
		
			$elements = $eventObj->getDocument()->getElementsByTagName('img');
			
			foreach ($elements as $element) {
				
				$class = $element->getAttribute('class');
				
				if (!preg_match('~\bsmiley\b~', $class)) {
					
					$external = true;
					$src = $element->getAttribute('src');
					
					//check for internal links
					if (ApplicationHandler::getInstance()->isInternalURL($src)) {
						$external = false;
					}
					
					//check for internal links via subdomain
					$parsedUrl = parse_url($src);
					
					$domainName = ApplicationHandler::getInstance()->getActiveApplication()->domainName;
					$domainName = preg_replace('~\:.*~', '', $domainName);
					
					if (preg_match("~$domainName~", $parsedUrl['host'])) {
						$external = false;
					}

					
					if ($external) {
						$alt = $element->getAttribute('alt');
						
						$element = $eventObj->renameTag($element, 'img-clickandload');
						$element->setAttribute('src', $src);
						
						if ($alt) {
							$element->setAttribute('alt', $alt);
						}
					}
				}
			}
		}
	}
}
